/*	file: myString.h

	declarartion of 'string' class
*/

#include <iostream.h>
#include <stdlib.h>
#include <string.h>

#ifndef STRING_H
#define STRING_H


class string 
{
public:

	string(size_t Size = 60) 
		{ size = Size; contents = new char[size]; contents[0] = '\0'; }
	string(char *newContents);
	string(const string& source);

	~string() { delete [] contents; }

	int length() const { return strlen(contents); }
	void resize(size_t newSize);

	string& operator=(const string& source);
	string& operator+=(const string& source);

	friend ostream& operator<<(ostream& output, const string& s);
	friend istream& operator>>(istream& input, string& s);

	bool operator==(const string& s) const;
	bool operator<(const string& s) const;
	bool operator>(const string& s) const;

	void Reverse(int start = -1, int end = -1);  // If start is negative, then it reverses
							// the whole string.
	void ReverseWords(void);

	char* getAsCharPoint() { return contents; }

private:

	char *contents;
	size_t size;
};

#endif /* STRING_H */
