//	Implementation of Board class

#include "board.h"
#include "room.h"
#include "fun.h"


Board::Board()
{
	finish = NULL;
	count = 0;
	
	AddFirst("");	//Creates default room, to be modified later
}

Board::Board(Board &b)
{
	if (b.start == NULL)
	{
		start = current = finish = NULL;		
		count = 0;
		AddFirst("");
	}

	else
	{
		finish = NULL;

		for (int i = 0; i < b.count; i++)
		{
			rooms[i] = b.rooms[i];
		}

		makeLinks(*this);

		count = b.count;
	}
}

Board::~Board()
{
	delete start;
	delete current;
	delete finish;
	
	delete [] rooms;
}

Board& Board::operator=(const Board &b)
{
	if (b.start == NULL)
	{
		start = current = finish = NULL;
		count = 0;
		AddFirst("");
	}

	else
	{
		finish = NULL;

		for (int i = 0; i < b.count; i++)
		{
			rooms[i] = b.rooms[i];
		}

		makeLinks(*this);

		count = b.count;
	}

	return *this;
}

void Board::MoveNorth()
{
	if (current->n != NULL)
	{
		current = current->n;
	}
	else
		MoveError();
}

void Board::MoveSouth()
{
	if (current->s != NULL)
	{
		current = current->s;
	}
	else
		MoveError();
}

void Board::MoveWest()
{
	if (current->w != NULL)
	{
		current = current->w;
	}
	else
		MoveError();
}

void Board::MoveEast()
{
	if (current->e != NULL)
	{
		current = current->e;
	}
	else
		MoveError();
}

void Board::MoveWarp()
{
	if (current->warp != NULL)
	{
		current = current->warp;
	}
	else
		MoveError();
}

void Board::AddNorth(char *Des, char *thingDes, char *thingName, int thingAttrib)
{
	if (current == NULL) //It's empty
	{
		AddFirst(Des, thingDes, thingName, thingAttrib);
		return;
	}
	if (current->n != NULL)		//Already a room to the north
	{
		cout << "Room already present to the north\n";
		return;
	}

	rooms[count].set(Des, thingDes, thingName, thingAttrib);

	current->n = &rooms[count];
	current->n->s = current;

	current->n->where = count;
	current->N = count;
	current->n->S = current->where;

	count++;
}

void Board::AddSouth(char *Des, char *thingDes, char *thingName, int thingAttrib)
{
	if (current == NULL) //It's empty
	{
		AddFirst(Des, thingDes, thingName, thingAttrib);
		return;
	}
	if (current->s != NULL)		//Already a room to the south
	{
		cout << "Room already present to the south\n";
		return;
	}

	rooms[count].set(Des, thingDes, thingName, thingAttrib);

	current->s = &rooms[count];
	current->s->n = current;

	current->s->where = count;
	current->S = count;
	current->s->N = current->where;

	count++;
}

void Board::AddWest(char *Des, char *thingDes, char *thingName, int thingAttrib)
{
	if (current == NULL) //It's empty
	{
		AddFirst(Des, thingDes, thingName, thingAttrib);
		return;
	}
	if (current->w != NULL)		//Already a room to the west
	{
		cout << "Room already present to the west\n";
		return;
	}

	rooms[count].set(Des, thingDes, thingName, thingAttrib);

	current->w = &rooms[count];
	current->w->e = current;
	
	current->w->where = count;
	current->W = count;
	current->w->E = current->where;

	count++;
}

void Board::AddEast(char *Des, char *thingDes, char *thingName, int thingAttrib)
{
	if (current == NULL) //It's empty
	{
		AddFirst(Des, thingDes, thingName, thingAttrib);
		return;
	}
	if (current->e != NULL)		//Already a room to the east
	{
		cout << "Room already present to the east\n";
		return;
	}

	rooms[count].set(Des, thingDes, thingName, thingAttrib);

	current->e = &rooms[count];
	current->e->w = current;

	current->e->where = count;
	current->E = count;
	current->e->W = current->where;

	count++;
}

void Board::AddWarp(char *Des, char *thingDes, char *thingName, int thingAttrib)
{
	if (current == NULL) //It's empty
	{
		AddFirst(Des, thingDes, thingName, thingAttrib);
		return;
	}
	if (current->warp != NULL)		//Already a room through the warp
	{
		cout << "Room already present through the warp\n";
		return;
	}

	rooms[count].set(Des, thingDes, thingName, thingAttrib);

	current->warp = &rooms[count];
	current->warp->warp = current;

	current->warp->where = count;
	current->Warp = count;
	current->warp->Warp = current->where;

	count++;
}

void Board::InsertItem(char *name, char *descript, int attrib)
{
	current->things.add ( name, descript, attrib );
}

void Board::AddFirst(char *Des, char *thingDes, char *thingName, int thingAttrib)
{
	if (count != 0)	//_Should_ only be called at top of the array
		cout << "Warning!!: AddFirst() called at non-zero count; Setting new starting room\n";

	rooms[count].set(Des, thingDes, thingName, thingAttrib);
	current = start = &rooms[count];
	current->where = count;
	count++;
}

void Board::AddFirst(char * Des)
{
	if (count != 0)   //_Should_ only be called at top of the array
		cout << "Warning!!: AddFirst() called at non-zero count; Replacing starting room\n";

	rooms[count].set(Des);
	current = start = &rooms[count];
	current->where = count;
	count++;
}

void Board::ViewRoom(void)
{
	if (current != NULL)
	{
		cout << current->descript << endl;
		
		if (current->is_item())
		{
			string cName, cDes;
			current->things.getName(cName);
			current->things.getDes(cDes);

			cout << "There is an item in this room, a " << cName
				 << ":\n" << cDes << endl;
		}
	}
	else
		cout << "Oddly, this room doesn't exist. Hmm...\n";	//Don't think this line COULD be executed...
}

void Board::ViewDebug(void) //Tell us some more about the room..
{
	bool dirs[5];

	cout << "You " << ( ( current->n != NULL ) ? "CAN " : "can't " ) << "go North" << endl;
	cout << "You " << ( ( current->s != NULL ) ? "CAN " : "can't " ) << "go South" << endl;
	cout << "You " << ( ( current->w != NULL ) ? "CAN " : "can't " ) << "go West" << endl;
	cout << "You " << ( ( current->e != NULL ) ? "CAN " : "can't " ) << "go East" << endl;
	cout << "You " << ( ( current->warp != NULL ) ? "CAN " : "can't " ) << "go through a Warp" << endl;
}

void Board::MoveError()
{
	cout << "You can't move in that direction\n";
}

void Board::Connect(Room *r, char dir)
{
	dir = tolower(dir);

	if (dir == 'n')
	{
		if (r->s != NULL || current->n != NULL)
		{
			cout << "Error, one of the rooms already has a connection there\n";
			return;
		}
		
		current->n = r;
		r->s = current;

		r->S = current->where;
		current->N = r->where;
	}
		
	else if (dir == 's')
	{
		if (r->n != NULL || current->s != NULL)
		{
			cout << "Error, one of the rooms already has a connection there\n";
			return;
		}

		current->s = r;
		r->n = current;

		r->N = current->where;
		current->S = r->where;
	}
	
	else if (dir == 'w')
	{
		if (r->e != NULL || current->w != NULL)
		{
			cout << "Error, one of the rooms already has a connection there\n";
			return;
		}

		current->w = r;
		r->e = current;

		r->E = current->where;
		current->W = r->where;
	}

	else if (dir == 'e')
	{
		if (r->w != NULL || current->e != NULL)
		{
			cout << "Error, one of the rooms already has a connection there\n";
			return;
		}

		current->e = r;
		r->w = current;

		r->W = current->where;
		current->E = r->where;
	}

	else if (dir == 'a')
	{
		if (r->warp != NULL || current->warp != NULL)
		{
			cout << "Error, one of the rooms already has a connection there\n";
			return;
		}

		current->warp = r;
		r->warp = current;

		r->Warp = current->where;
		current->Warp = r->where;
	}

	else
	{
		cout << "Error: Room::Connect() called with invalid direction specified\n";
	}
}

void Board::SetCurrentR(char *Des, char *thingDes, char *thingName, int thingAttrib)
{
	if (current == NULL)
		return;
	current->set(Des, thingDes, thingName, thingAttrib);
}

void Board::SetCurrentR(char *Des)
{
	if (current == NULL)
		return;
	current->set(Des);
}

ostream& operator<<(ostream &out, const Board &b)
{
	for (int i = 0; i < b.count; i++)
	{
		out << b.rooms[i];
	}

	return out;
}

istream& operator>>(istream &in, Board &b)
{
	for (int i = 0; !in.eof(); i++)
	{
		in >> b.rooms[i];
	}

	makeLinks(b);
	
	return in;
}

void makeLinks(Board &b)
{
	b.current = b.start = &b.rooms[0];

	for (int i = 0; i < b.count; i++)
	{
		if (b.rooms[i].N != 999999)
		{
			b.rooms[i].n = &b.rooms[b.rooms[i].N];
		}
		else
		{
			b.rooms[i].n = NULL;
		}

		if (b.rooms[i].S != 999999)
		{
			b.rooms[i].s = &b.rooms[b.rooms[i].S];
		}
		else
		{
			b.rooms[i].s = NULL;
		}

		if (b.rooms[i].W != 999999)
		{
			b.rooms[i].w = &b.rooms[b.rooms[i].W];
		}
		else
		{
			b.rooms[i].w = NULL;
		}

		if (b.rooms[i].E != 999999)
		{
			b.rooms[i].e = &b.rooms[b.rooms[i].E];
		}
		else
		{
			b.rooms[i].e = NULL;
		}

		if (b.rooms[i].Warp != 999999)
		{
			b.rooms[i].warp = &b.rooms[b.rooms[i].Warp];
		}
		else
		{
			b.rooms[i].warp = NULL;
		}
	}
}
