#include <iostream.h>
#include "myString.h"

#ifndef PLIST_H
#define PLIST_H

struct pickup
{
	string name;
	string des;
	int attrib;

	pickup * next;
	pickup * prev;
};

/*
	Insert values for pickup.attrib, most are just ideas...
	0 - Invalid, no item in this room
	1 - Good general item, nonfunctional (Llama)
	2 - Bad general item, nonfunctional (Alpaca)
	3 - Map item (?)
	4 - Thief detector
	5 - Geneticist (for cloning llamas)
*/

class Plist
{
public:
	Plist ();
	Plist ( string name, string des, int attrib );
	Plist ( const Plist& p );

	~Plist ();

	// ** Move current somewhere
	// ** Return true if successful
	bool mNext (); 
	bool mPrev ();
	bool mHead ();
	bool mTail ();

	void add ( string name, string des, int attrib ); //add to tail of list
	void rem (); //Remove current pickup
	void clear () { while ( current != NULL ) rem (); }

	bool getName (string &s);
	bool getDes (string &s);
	bool getAttrib (int &i);

	bool isEmpty () const { return empty; }

	friend ostream& operator<<(ostream &out, const Plist &p);

private:
	pickup * head;
	pickup * current;
	pickup * tail;

	bool empty;
};

#endif /* PLIST_H */
