#include "Plist.h"

Plist::Plist ()
{
	head = current = tail = NULL;
	empty = true;
}

Plist::Plist ( string name, string des, int attrib )
{
	pickup * n = new pickup;

	n->name = name;
   n->des = des;
   n->attrib = attrib;
   n->next = NULL;
	n->prev = NULL;

   head = current = tail = n;
   empty = false;
}

Plist::Plist ( const Plist& p )
{
	head = current = tail = NULL;
	empty = true;

	pickup * helper = p.head;

	while ( helper != NULL )
	{
		add ( helper->name, helper->des, helper->attrib );

		helper = helper->next;
	}
}

Plist::~Plist ()
{
	while ( current != NULL )
		rem ();
}

bool Plist::mNext ()
{
	if ( (current != NULL) && (current != tail) )
	{
		current = current->next;
		return true;
	}
	else
		return false;
}

bool Plist::mPrev ()
{
	if ( (current != NULL) && (current != head) )
	{
		current = current->prev;
		return true;
	}
	else
		return false;
}

bool Plist::mHead ()
{
	current = head;
	return current != NULL;
}

bool Plist::mTail ()
{
	current = tail;
	return current != NULL;
}

void Plist::add ( string name, string des, int attrib )
{
	empty = false;

	pickup * n = new pickup;

	n->name = name;
	n->des = des;
	n->attrib = attrib;

	n->prev = tail;
	n->next = NULL;
	tail = n;
}

void Plist::rem ()
{
	if ( current == NULL )
		return;

	pickup * helper = current;

	if ( helper == head )
	{
		head = current = helper->next;
		helper->next->prev = NULL;
		delete helper;
	}
	else if ( helper == tail )
	{
		tail = current = helper->prev;
		helper->prev->next = NULL;
		delete helper;
	}
	else
	{
		current = helper->prev->next = helper->next;
		helper->next->prev = helper->prev;
		delete helper;
	}
}

bool Plist::getName (string &s)
{
	if ( current != NULL )
	{
		s = current->name;
		return true;
	}
	else
		return false;
}

bool Plist::getDes (string &s)
{
	if ( current != NULL )
	{
		s = current->des;
		return true;
	}
	else
		return false;
}

bool Plist::getAttrib (int &i)
{
	if ( current != NULL )
	{
		i = current->attrib;
		return true;
	}
	else
		return false;
}

// friends

ostream& operator<<(ostream &out, const Plist &p)
{
	pickup * help = p.head;

	while ( help != NULL )
	{
		out << help->des << "~" << endl;
		out << help->name << "~" << endl;
		out << help->attrib << endl;

		help = help->next;
	}

	return out;
}

