//Implementation of Room class, etc.

#include "room.h"

Room::Room()
{
	descript = "";
	n = s = w = e = warp = NULL;
	N = S = W = E = Warp = where = 999999;	//6 9's = invalid
}

Room::Room(char *Des)
{
	descript = Des;

	n = s = w = e = warp = NULL;
	where = 999999;
}

Room::Room(char *Des, char *thingDes, char *thingName, int thingAttrib)
{
	descript = Des;

	things.add ( thingDes, thingName, thingAttrib );

	n = s = w = e = warp = NULL;
	where = 999999;
}

void Room::clear()
{
	descript = "";
	things.clear ();
	//A lot like the def constr, huh?
	//Preserves connections to other Rooms
}

void Room::set(char *Des, char *thingDes, char *thingName, int thingAttrib)
{
	descript = Des;

	things.clear ();
	things.add ( thingDes, thingName, thingAttrib );
}

void Room::set(char *Des)
{
	descript = Des;
}

ostream& operator<<(ostream &out, const Room &r)
{
	string des, name;
	int att;

	out << r.descript << "~" <<endl;

	out << r.things; // has an endl already

	out << "*" << endl; // Shows that we're done ouptutting things

	out << r.where << endl;
	out << r.N << endl;
	out << r.S << endl;
	out << r.W << endl;
	out << r.E << endl;
	out << r.Warp << endl;
	out << endl;

	return out;
}

istream& operator>>(istream &in, Room &r)
{
	char des[121], name[31];
	int att;

	if (in.peek() == '\n')
		in.get();
	in.getline(r.descript.getAsCharPoint(), 120, '~');

	while ( in.peek() != '*' );
	{
//DEBUG
cout << "Looking for things in the room.." << endl;
		if (in.peek() == '\n')
			in.get();
		in.getline(des, 120, '~');

		if (in.peek() == '\n')
			in.get();
		in.getline(name, 30, '~');

		if (in.peek() == '\n')
			in.get();
		in >> att;

		r.things.add ( name, des, att );
	}

	if (in.peek() == '\n')
		in.get();
	in >> r.where;
	
	if (in.peek() == '\n')
		in.get();
	in >> r.N;

	if (in.peek() == '\n')
		in.get();
	in >> r.S;

	if (in.peek() == '\n')
		in.get();
	in >> r.W;

	if (in.peek() == '\n')
		in.get();
	in >> r.E;

	if (in.peek() == '\n')
		in.get();
	in >> r.Warp;

	in.get();
	
	return in;
}

