
#include "myString.h"


string::string(char *newContents)
{
	size = strlen(newContents) + 1;
	contents = new char[size]; 
	strcpy(contents, newContents); 
}

string::string(const string& source)
{ 
	size = source.size;
	contents = new char[size]; 
	strcpy(contents, source.contents); 
}

string& string::operator=(const string& source)
{
	if ( &source == this )
		return *this;

	delete [] contents;

	size = source.size;
	contents = new char[size];
	strcpy(contents, source.contents);

	return *this;
}

void string::resize(size_t newSize)
{
	if ((size == newSize) || (newSize == 0))
		return;

	char *tmp = new char[newSize];
	if (size < newSize)
	{
		for (size_t i = 0; i < size; i++)
		{
			tmp[i] = contents[i];
		}
	}
	else
	{
		tmp[0] = '\0';
	}
	size = newSize; 
	delete [] contents;
	contents = tmp;
}

string& string::operator+=(const string& source)
{
	int oldLength = length();
	int sourceLength = source.length();
	int newLength = oldLength + sourceLength;

	char *newContents = new char[newLength];
	char *beginingPart2 = newContents + oldLength;

	strcpy(newContents, contents);
	strcpy(beginingPart2, source.contents);

	delete [] contents;
	contents = newContents;

	return *this;
}


ostream& operator<<(ostream& output, const string& s) // These need to be made more robust
{
	output << s.contents;
	return output;
}

istream& operator>>(istream& input, string& s)
{
	char c = 'a'; // anything but '\n'
	size_t index = 0;

	while (!input.eof())
	{
		c = input.get();
		if (c != '\n')
		{
			s.contents[index] = c;
			index++;
			if (index >= s.size)
			{
				s.resize(s.size + 10);
			}
		}
		else if (index > 1)
			break;
	}
	s.contents[index] = '\0';
	return input;
}

bool string::operator==(const string& s) const 
{
	if (strcmp(contents, s.contents) == 0)
		return true;
	else
		return false;
}

bool string::operator<(const string& s) const 
{
	if (strcmp(contents, s.contents) < 0)
		return true;
	else
		return false;
}

bool string::operator>(const string& s) const
{
	if (strcmp(contents, s.contents) > 0)
		return true;
	else
		return false;
}

// This reverse does a little more than the one I did in class, we will
// go over it on Monday.
void string::Reverse(int start, int end) // If start is negative, then it reverses
{										 // the whole string.
	if ((start < 0) || (end < 0))
	{
		start = 0;
		end = length() - 1;
	}
	else if (end > length())
	{
		end = length();
	}

	char tmp;
	while (start < end)
	{
		tmp = contents[start];
		contents[start] = contents[end];
		contents[end] = tmp;
		start++;
		end--;
	}
}

void string::ReverseWords(void)
{
	Reverse();

	int start = 0;
	int end = 0;

	while (contents[end] != '\0')
	{
		end++;
		if (contents[end] == ' ')
		{
			Reverse(start, end - 1); // Don't reverse the space;
			end++;
			start = end;
		}
	}
}

