/*
	A text adventure game engine
	(c) 1999-2002 Brian Kelly
	Licensed under the GNU GPL, see LICENSE in included distribution, or at http://gnu.org/

*/

#include <iostream.h>
#include <fstream.h>
#include "board.h"
#include "player.h"
#include "fun.h"

void makeMap(void);	//Map editor
void playMap(void);	//Game proper, actually specific to 'Llama Hunter'
void MoveRoom(Board &b);
void AddRoom(Board &b);
void EditRoom(Board &b);
void SaveMap(Board &b);
void LinkRooms(Board &b);	//For making a room connect to a pre-existing room
void AddItemToRoom(Board &b);
void LoadMap(Board &b);

int main()
{
	cout << "\t\tWelcome to 'Llama Herder!!'\nThis program is freely redistributable" << endl << endl;
	cout << "This is pretty much a test of my coding skills and shot at\n"
		 << "making something entertaining. Here's hoping." << endl;

	char choice;

	do
	{
		cout << "What do you want to do?\n\n"
			 << "(C)reate a map (can take awhile..)\n"
			 << "(P)lay a map\n"
			 << "(Q)uit\n\n> ";
		cin >> choice;

		choice = tolower(choice);	//Should be lowering case of letter, it's not....

		switch(choice)
		{
		case 'c':
			{
				makeMap();
				break;
			}
		case 'p':
			{
				playMap();
				break;
			}
		case 'q':
			{
				break;
			}
		default:
			{
				cout << "\nBad input" << endl;
				break;
			}

			cout << endl;
		}
	}while(choice != 'q');

	return 0;
}

void makeMap ( void )
{
	cout << "Making a map...\n";

	Board b;

	Room * marker;
	marker = NULL;

	char choice;

	if (b.manyRooms() == 0)
	{
		cout << "No rooms yet, beginning start room creation...\n";
		AddRoom(b);
	}

	do
	{
		cout << "What would you like to do?\n\n";
		cout << "(M)ove to a adjascent room\n"
           << "(A)dd an adjascent room\n"
           << "(P)ut an item in this room\n"
           << "(V)iew this room\n"
           << "(C)hange this room\n"
           << "(S)ave the map to a file (must be saved before it can be played)\n"
           << "p(U)t a marker in this room (various uses, one at a time)\n"
           << "c(O)nnect marked room with current\n"
           << "(L)oad a saved map\n"
           << "(R)eturn to main menu\n\n> ";
		cin >> choice;

		choice = tolower(choice);

		switch(choice)
		{
		case 'm':
			{
				MoveRoom(b);
				break;
			}

		case 'a':
			{
				AddRoom(b);
				break;	
			}

		case 'p':
			{
				AddItemToRoom(b);
				break;
			}

		case 'v':
			{
				b.ViewRoom();
				cout << endl;
				b.ViewDebug();
				cout << endl;
				break;
			}

		case 'c':
			{
				EditRoom(b);
				break;
			}

		case 's':
			{
				SaveMap(b);
				break;
			}

		case 'u':
			{
				b.isEqualCurrent ( marker );
				break;
			}

		case 'o':
			{
				if (b.isEqualCurrent (marker) )
				{
					cout << "Can't connect room to itself...\n";
				}
				else if (marker == NULL)
				{
					cout << "Marker not set. Remember, it needs to be reset after each use\n";
				}
				else
				{
					char input;
					cout << "In which direction would you like the marked room to sit from the current?\n"
						 << "[N/S/W/E/wArp] ";
					cin >> input;

					b.Connect(marker, input);

					marker = NULL;
				}
				
				break;
			}

		case 'l':
			{
				LoadMap(b);
				break;
			}

		case 'r':
			{
				break;
			}

		default:
			{
				cout << "\nBad input!!\n\n";
				break;
			}
		}
	}while(choice != 'r');

	return;
}

void playMap(void)	//The game
{
	//Setup: input map from file, have hard-coded mapfile name
	
	//Explain premise

	//First room:
	
	//Move north
	//Move south
	//Move west
	//Move east
	//Search for item
	//Search for warp
	//Re-view room
	
}

void MoveRoom(Board &b)
{
	char choice;
	
	cout << "Which direction would you like to move?\n";
	cout << "(N)orth\n"
		 << "(S)outh\n"
		 << "(W)est\n"
		 << "(E)ast\n"
		 << "w(A)rp\n"
		 << "(D)on't move\n\n> ";
	cin >> choice;

	choice = tolower(choice);

	switch(choice)
	{
	case 'n':
		{
			b.MoveNorth();
			break;
		}

	case 's':
		{
			b.MoveSouth();
			break;
		}

	case 'w':
		{
			b.MoveWest();
			break;
		}

	case 'e':
		{
			b.MoveEast();
			break;
		}

	case 'a':
		{
			b.MoveWarp();
			break;
		}

	case 'd':
		{
			break;
		}

	default:
		{
			cout << "Bad input\n";
			break;
		}
	}
}

void AddRoom(Board &b)
{
	cout << "First, we've gotta decsribe the room\n"
		 << "Don't worry, if you make an error, you can decide not to add the room\n";

	cout << "Creating room:\n\n";
	
	char roomDes[121];
	cout << "What description should appear?\nReturn characters are okay, but not good form.\n"
		 << "End it all with a '~' tilde character, then push enter\nYou have 120 characters. Please type it now\n\n";

	if (cin.peek() == '\n')
		cin.get();
	cin.getline(roomDes, 121, '~');

	cout << "Inputted as:\n" << roomDes << endl;

	char item;
	cout << "Will there be an item in this room? [y/n] ";
	cin >> item;
	
	
	char thingyName[31] = "";	//If there isn't an item present,
	char thingyDes[81] = "";	//invalid values are passed to Add***... functions
	size_t kind = 0;

	if (item == 'y')
	{
		cout << "What will the item be called? Again, end it with a '~' tilde.\nYou have 30 characters.\n";

		if (cin.peek() == '\n')
			cin.get();
		cin.getline(thingyName, 31, '~');

		cout << "Inputted as:\n" << thingyName << endl;

		cout << "Now, please describe the item, same rules, 80 characters\n";

		if (cin.peek() == '\n')
			cin.get();
		cin.getline(thingyDes, 80, '~');

		cout << "Inputted as:\n" << thingyDes << endl;

		cout << "What class of item is this? [1/2/3/4/5] ";
		cin >> kind;

		if (kind == 0)	//0 = invalid = bad if we've already decided there's an item...
			kind = 5;
	}

	char choice;
	
	cout << "In which direction would you like to add?\n";
	cout << "(N)orth\n"
		 << "(S)outh\n"
		 << "(W)est\n"
		 << "(E)ast\n"
		 << "w(A)rp\n"
		 << "(D)on't add\n\n> ";
	cin >> choice;

	choice = tolower(choice);

	switch(choice)
	{
	case 'n':
		{
			b.AddNorth(roomDes, thingyDes, thingyName, kind);
			break;
		}

	case 's':
		{
			b.AddSouth(roomDes, thingyDes, thingyName, kind);
			break;
		}

	case 'w':
		{
			b.AddWest(roomDes, thingyDes, thingyName, kind);
			break;
		}

	case 'e':
		{
			b.AddEast(roomDes, thingyDes, thingyName, kind);
			break;
		}

	case 'a':
		{
			b.AddWarp(roomDes, thingyDes, thingyName, kind);
			break;
		}

	case 'd':
		{
			break;
		}

	default:
		{
			cout << "Bad input\n";
			break;
		}
	}
}

void EditRoom(Board &b)
{
	cout << "Current room status:\n";
	b.ViewRoom();
	cout << "Continue? [y/n]";
	char cont;
	cin >> cont;

	if (cont != 'y')
	{
		cout << "Returning to menu...\n";
		return;
	}

	//Following ripped from AddRoom() function:
	char roomDes[121];
	cout << "What description should appear?\nReturn characters are okay, but not good form.\n"
		 << "End it all with a '~' tilde character, then push enter\nYou have 120 characters. Please type it now\n\n";

	if (cin.peek() == '\n')
		cin.get();
	cin.getline(roomDes, 121, '~');

	cout << "Inputted as:\n" << roomDes << endl;

	char item;
	cout << "Will there be an item in this room? [y/n] ";
	cin >> item;
	
	
	if (item == 'y')
	{
		char thingyName[31];
		char thingyDes[81]; 
		int kind;

		cout << "What will the item be called? Again, end it with a '~' tilde.\nYou have 30 characters.\n";

		if (cin.peek() == '\n')
			cin.get();
		cin.getline(thingyName, 31, '~');

		cout << "Inputted as:\n" << thingyName << endl;

		cout << "Now, please describe the item, same rules, 80 characters\n";

		if (cin.peek() == '\n')
			cin.get();
		cin.getline(thingyDes, 80, '~');

		cout << "Inputted as:\n" << thingyDes << endl;

		cout << "What class of item is this? [1/2/3/4/5] ";
		cin >> kind;

		if (kind == 0)	//0 = invalid = bad if we've already decided there's an item...
			kind = 5;

		b.SetCurrentR(roomDes, thingyDes, thingyName, kind);
	}
	else
	{
		b.SetCurrentR(roomDes);
	}
}

void SaveMap(Board &b)
{
	char fname[256];
	cout << "Name of file to save: ";
	if (cin.peek() == '\n')
		cin.get();
	cin.getline(fname, 256);

	ofstream fout;
	fout.open(fname);

	fout << b;

	fout.close();
}

void AddItemToRoom(Board &b)
{
	char name[30], descript[120];
	size_t attrib;

	cout << "Creating the item...\n";
	cout << "What is the name of the item? You have 30 characters, spaces and returns allowed.\n"
		 << "End with a '~' tilde\n";
	if (cin.peek() == '\n')
		cin.get();
	cin.getline(name, 30, '~');

	cout << "Describe the item. You have 120 characters, spaces and returns allowed.\n"
		 << "End with a '~' tilde\n";
	if (cin.peek() == '\n')
		cin.get();
	cin.getline(descript, 120, '~');

	cout << "What class of item is this? [1/2/3/4/5]\n> ";
	cin >> attrib;

	b.InsertItem(name, descript, attrib);
}

void LoadMap(Board &b)
{
	ifstream fin;
	char fname[256];
	
	cout << "What is the name of the map file you wish to open?\n> ";
	if (cin.peek() == '\n')
		cin.get();
	cin.getline(fname, 255);

	fin.open(fname);

	fin >> b;

	fin.close();
}
