//	Declaration of Board object for storing Rooms

#include <assert.h>
#include "room.h"

#ifndef BOARD_H
#define BOARD_H

class Board
{
public:

	Board();
	Board(Board &b);
	~Board();
	Board& operator=(const Board &b);

	void MoveNorth(void);
	void MoveSouth(void);
	void MoveWest(void);
	void MoveEast(void);
	void MoveWarp(void);

	//Adds at current, if empty, adds at start; adds at end of array
	void AddNorth(char *Des, char *thingDes = "", char *thingName = "", int thingAttrib = 0);
	void AddSouth(char *Des, char *thingDes = "", char *thingName = "", int thingAttrib = 0);
	void AddWest(char *Des, char *thingDes = "", char *thingName = "", int thingAttrib = 0);
	void AddEast(char *Des, char *thingDes = "", char *thingName = "", int thingAttrib = 0);
	void AddWarp(char *Des, char *thingDes = "", char *thingName = "", int thingAttrib = 0);

	void InsertItem(char *name, char *descript, int attrib);	//Puts an item into an item-less room

	size_t manyRooms(void) const { return count; }
	bool is_item(void) const { assert(current != NULL);
							 return (!current->things.isEmpty() ); }	//True if there's an item in the current room
	virtual void ViewRoom(void);
	virtual void ViewDebug(void);

	void Connect(Room *r, char dir);	//dir is single char telling which direction target of r will be connected to 'current'
										//dir must = n,s,w,e or a (a = warp), capitalization ignored

	//Room* GetCurrentP(void) const { return current; }
		// Unsafe function there, below replace, are safer and do more..
	bool isEqualCurrent ( Room * r ) { return (r == current) && (current != NULL); }
	bool isEqualStart ( Room * r ) { return (r == start) && (start != NULL); }
	bool isEqualFinish ( Room * r ) { return (r == finish) && (finish != NULL); }

	void SetCurrentR(char *Des, char *thingDes, char *thingName, int thingAttrib);
	void SetCurrentR(char *Des);

	friend ostream& operator<<(ostream &out, const Board &b);
	friend istream& operator>>(istream &in, Board &b);

	friend void makeLinks(Board &b);	//Sets up pointers in b.rooms[]

protected:

	Room *start;
	Room *current;
	Room *finish;	//Still not sure what to do with finish... maybe put it in 'Player' class?

	Room rooms[80];
	size_t count;	//How many rooms?

	void MoveError();
	void AddFirst(char *Des, char *thingDes, char *thingName, int thingAttrib);
	void AddFirst(char *Des);
	void SetFinish() { finish = current; }
};

#endif /* BOARD_H */

