#!/usr/bin/perl -w

# Copyright 2003, Jonathan R. Finger (jonathan_finger@hotmail.com).
# All rights reserved.
# This library is free software; you can redistribute it and/or modify
# it under the terms of the GNU Public Liscence (GPL) version 2
# or later.



package message_info;
require Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw(create_message_window destroy_message_window);
use strict;
use Tk;
use Tk::Wm;

my $message_window;
my $button_clicked;
my $wait = 0;
my $grab;
my $grab_savefocus;

sub _button_clicked
{
  $button_clicked = shift;
  $wait = 1;
  destroy_message_window();
}

sub destroy_message_window
{
  if ($grab)
    {
      $grab->grabRelease();
      $grab = undef;
      if ($grab_savefocus)
	{
	  $grab_savefocus->focus();
	}
      $grab = 0;
    }
  if ($message_window)
     {
       $message_window->grabRelease();
       $message_window->destroy();
     }
  $message_window = undef;
}

my $announce_font = "-adobe-courier-bold-r-normal--34-240-100-100-m-200-iso8859-1";

sub create_message_window
{
  if ($message_window && Exists($message_window))
    {
      $message_window->destroy();
    }
  $message_window = MainWindow->new();
  $message_window->title("Messages");
  my $message = shift;
  my $hash =shift;
  my @args = ("ROText");
  if ($hash->{args})
    {
      push @args, @{$hash->{args}};
    }
  my $textbox = $message_window->Scrolled(@args)->pack(-expand => 1, -fill => 'both');
  if ($hash->{tags})
    {
      foreach my $ref (@{$hash->{tags}})
        {
         $textbox->tagConfigure(@$ref);
        }
   }
  if (ref($message))
    {
      foreach my $ref (@$message)
        {
          $textbox->insert('end', @$ref);
	}
    }
  elsif ($hash->{announce})
    {
      $textbox->tagConfigure('announce', -font => $announce_font);
      $textbox->insert('end', $message, "announce");
    }
  else
    {
      $textbox->insert('end', $message);
    }
  if (!$hash || !$hash->{buttons})
    {
      my $widget = $message_window->Button(-text => "Close", -command => [\&_button_clicked, undef])->pack();
      $widget->focus();
    }
  if ($hash)
    {
      if ($hash->{entries})
	{
          foreach my $ref (@{$hash->{entries}})
	    {
 	      $textbox->insert('end', "\n");
 	      my $w = $textbox->Label(-text => $ref->[0]);
              $textbox->windowCreate('end', -window => $w);
              if ($ref->[1])
                {
		  my @fields = (-textvariable => $ref->[1]);
                  if ($ref->[2]) 
                    {
		      push @fields, "-width", $ref->[2];
		    }
		  $w = $textbox->Entry(@fields);
                  $textbox->windowCreate('end', -window => $w);
	        }
	    }
	}
      if ($hash->{checkbuttons})
	{
          foreach my $ref (@{$hash->{checkbuttons}})
	    {
 	      $message_window->Checkbutton(-text => $ref->[0],
    		             	           -variable => $ref->[1])->pack();
	    }
	}
      if ($hash->{buttons})
	{
          my $focus_widget;
          foreach my $ref (@{$hash->{buttons}})
	    {
              my $command;
              if ($ref->[2])
		{
                  $command = [$ref->[2], $ref->[1]];
		}
              else
		{
                  $command = [\&_button_clicked, $ref->[1]];
		}

 	      my $widget = $message_window->Button(-text => $ref->[0], -command => $command)->pack();
              if ($ref->[3])
		{
                  $focus_widget = $widget;
		}
	    }
          if ($focus_widget)
	    { $focus_widget->focus() }
	}
     if ($hash->{grab})
       {
	 $grab = $hash->{grab};
	 $grab_savefocus = $grab->focusCurrent();
	 $grab->focus();
	 $grab->grab();
	 $message_window->waitVisibility();
         $hash->{wait} ||= 1;
       }
     if ($hash->{wait})
       {
          $wait = 0;
          $message_window->protocol('WM_DELETE_WINDOW', sub { _button_clicked("") });
          $message_window->waitVariable(\$wait);
          return($button_clicked);
       }
    }
  return(undef);
}


1;
