/*

 (c) 2002 Brian Kelly under the terms of the GNU GPL
   http://www.gnu.org/copyleft/gpl.html

*/

#include <math.h>
#include "trans.h"

trans::trans()
{
	amt = 0;
}

trans::trans( int high, int low )
{
	amt = (high*100) + low;
}

trans::trans( char amt[] )
{
	int total = 0, tmp, pastDec = 0;
	bool succ = true, neg = false;

	int i = 0;
	if ( amt[i] == '-' ) {
		i++;
		neg = true;
	}

	for ( i; amt[i] != '\0'; i++ )
	{
		if ( toInt( amt[i], tmp ) )
		{
			if (pastDec > 2) { 
				//ignore char, do nothing
			}
			else {
				total *= 10;
				total += tmp;
				if ( pastDec > 0 )
					pastDec++;
			}
		}
		else if ( (amt[i] == '.') && (pastDec == 0) )
		{
			pastDec = 1;
		}
		else
		{
			succ = false;
		}
	}

	if (succ) {
		if (neg) {
			total *= -1;
		}
		if (pastDec == 0) {
			total *= 100;
		}
		this->amt = total;
	}
	else {
		this->amt = 0;
	}
}

ostream& operator<<( ostream& out, const trans &t )
{
	int c = abs( t.amt%100 );
	out << (t.amt/100) << ".";

	if ( c < 10 )
		out << "0";

	out << c << endl;
	return out;
}

istream& operator>>( istream& in, trans &t )
{
	char buffer[30];
	in.getline( buffer, 29 );
	trans s( buffer );
	t = s;

	return in;
}

